/**
 * \file sdc_ctl.h
 *
 * \brief SDC_CTL : Define types, enums, structs for actions (operations)
 *
 * \author Christoph Gellner (cgellner@de.adit-jv.com)
 *
 * \copyright (c) 2015 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 *
 ***********************************************************************/

#ifndef __SDC_CTL_H_
#define __SDC_CTL_H_

typedef struct data_t {
    unsigned char *data;
    size_t len;
} sdc_unittest_data_t;

#define ACTION_NAME_INSTALL                 "install"
#define ACTION_NAME_REMOVE                  "remove"
#define ACTION_NAME_NON_FORMATTED_WRAP      "wrap"
#define ACTION_NAME_NON_FORMATTED_UNWRAP    "unwrap"
#define ACTION_NAME_FORMATTED_WRAP          "fwrap"
#define ACTION_NAME_FORMATTED_UNWRAP        "funwrap"
#define ACTION_NAME_NON_FORMATTED_ENCRYPT   "encrypt"
#define ACTION_NAME_NON_FORMATTED_DECRYPT   "decrypt"
#define ACTION_NAME_FORMATTED_ENCRYPT       "fencrypt"
#define ACTION_NAME_FORMATTED_DECRYPT       "fdecrypt"
#define ACTION_NAME_NON_FORMATTED_SIGN      "sign"
#define ACTION_NAME_NON_FORMATTED_VERIFY    "verify"
#define ACTION_NAME_FORMATTED_SIGN          "fsign"
#define ACTION_NAME_FORMATTED_VERIFY        "fverify"
#define ACTION_NAME_NON_FORMATTED_DGST      "dgst"
#define ACTION_NAME_RNG                     "rng"
#define ACTION_NAME_ARCH_INFO               "archinfo"


typedef enum logging {
    LOGGING_QUIET,
    LOGGING_NORMAL,
    LOGGING_VERBOSE
} logging_t;

#endif
